#!/bin/sh

set_settings()
{
    #dprint 0 "debug" "calling function 'set_settings' \"$1\" \"$2\" \"$3\" \"$4\" \"$5\" \"$6\" \"$7\" \"$8\" \"$9\" \"${10}\" \"${11}\" \"${12}\""

    local NEW_HOSTNAME=$1
    local NEW_IP_ADDRESS=$2
    local NEW_SUBNET_MASK=$3
    local NEW_GATEWAY=$4
    local NEW_IPV6_ADDRESS=$5
    local NEW_IPV6_PREFIX_LENGTH=$6
    local NEW_IPV6_GATEWAY=$7
    local NEW_DNS=$8
    local NEW_DNS2=$9
    local NEW_DNS3=${10}

    local CONFIG_FROM=${11}
    local INTERFACE=${12}

    #ha_status=`/opt/TrendMicro/DTAS/cluster/bin/ha_ctrl.py --current-status`
    ha_status="single"

    cmd_prefix=""
    if [ "${INTERFACE}" == "eth1" ]; then
        cmd_prefix="ip netns exec sys-port-ns"
    fi
	
    if [ "${NEW_HOSTNAME}" != "" ]; then
        if ! $(is_hostname_valid "${NEW_HOSTNAME}") ; then
            output_invalid "1" "invalid hostname"
            #dprint 0 "err" "invalid hostname:${NEW_HOSTNAME}."
            dprint "ERROR" "Invalid hostname:${NEW_HOSTNAME}"
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
        fi
        
        host=`hostname`
        if [ "$ha_status" = "primary" ] && [ "${NEW_HOSTNAME}" != "$host" ]; then
            output_invalid "19" "invalid hostname"
            #dprint 0 "err" "invalid hostname:${NEW_HOSTNAME}.HA status:$ha_status"            
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
        fi
    fi
    if [ "${NEW_IP_ADDRESS}" = "" ] && [ "${NEW_IPV6_ADDRESS}" = "" ]; then
        output_invalid "9" "Both IPv4 and IPv6 Address fields cannot be empty"
        dprint "ERROR" "Both IPv4 and IPv6 Address fields cannot be empty"
        #dprint 0 "err" "Both IPv4 and IPv6 Address fields cannot be empty"
        exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
    fi

  if [ "${NEW_IP_ADDRESS}" = "" ]; then
    if [ "${NEW_SUBNET_MASK}" != "" ] || [ "${NEW_GATEWAY}" != "" ]; then
        output_invalid "15" "IPv4 address cannot be empty if IPv4 subnet netmask, gateway is configured"
        dprint "ERROR" "IPv4 address cannot be empty if IPv4 subnet netmask, gateway is configured"
        exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
    fi
  else
    if ! $(is_ip_address_valid "${NEW_IP_ADDRESS}") ; then
        output_invalid "2" "invalid ip_address"
        dprint "ERROR" "invalid ip_address:${NEW_IP_ADDRESS}."
        #dprint 0 "err" "invalid ip_address:${NEW_IP_ADDRESS}."
        exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
    fi

    if ! $(is_netmask_valid "${NEW_SUBNET_MASK}") ; then
        output_invalid "3" "invalid subnet_mask"
        dprint "ERROR" "invalid subnet_mask:${NEW_SUBNET_MASK}."
        #dprint 0 "err" "invalid subnet_mask:${NEW_SUBNET_MASK}."
        exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
    fi

    if ! $(is_gateway_valid "${NEW_IP_ADDRESS}" "${NEW_SUBNET_MASK}" "${NEW_GATEWAY}") ; then
        output_invalid "4" "invalid gateway"
        dprint "ERROR" "invalid gateway:${NEW_GATEWAY}."
        exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
    fi

    local current_ipv4=$(${cmd_prefix} ip -f inet -o addr show ${INTERFACE} | sed -n '1p' | awk '{print $4}' | sed 's/\/.*$//g')
 
    if [ "${current_ipv4}" != "" ] && [ "${current_ipv4}" != "${NEW_IP_ADDRESS}" ]; then
        if ! ${cmd_prefix} /sbin/arping -c 2 -w 3 -D -I ${INTERFACE} ${NEW_IP_ADDRESS} >/dev/null 2>&1 ; then
            output_invalid "17" "some other host already uses ipv4 address:${NEW_IP_ADDRESS}."
            dprint "ERROR" "some other host already uses ipv4 address:${NEW_IP_ADDRESS}."
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
        fi
    fi
  fi


  if [ "${NEW_IPV6_ADDRESS}" = "" ]; then
    if [ "${NEW_IPV6_PREFIX_LENGTH}" != "" ] || [ "${NEW_IPV6_GATEWAY}" != "" ]; then
        output_invalid "16" "IPv6 address cannot be empty if IPv6 subnet prefix length, gateway is configured."
        dprint "ERROR" "IPv6 address cannot be empty if IPv6 subnet prefix length, gateway is configured."
        exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
    fi
  else
    if ! $(is_ipv6_address_valid "${NEW_IPV6_ADDRESS}") ; then
        output_invalid "10" "invalid ipv6_address"
        dprint "ERROR" "invalid ipv6_address:${NEW_IPV6_ADDRESS}."
        exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
    fi

    if ! $(is_ipv6_prefix_length_valid "${NEW_IPV6_PREFIX_LENGTH}") ; then
        output_invalid "11" "invalid ipv6_prefix_length"
        dprint "ERROR" "invalid ipv6_prefix_length:${NEW_IPV6_PREFIX_LENGTH}."
        exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
    fi

    local upcase=$(echo ${NEW_IPV6_ADDRESS:0:5} | tr '[a-z]' '[A-Z]')
    if [ "${upcase}" = "FE80:" ]; then
        # Not allow link local address
        output_invalid "10" "link local address not allowed"
        dprint "ERROR" "link local address not allowed:${NEW_IPV6_ADDRESS}."
        exit 1
    else
        if ! $(is_ipv6_address_valid "${NEW_IPV6_GATEWAY}") ; then
            output_invalid "12" "invalid ipv6_gateway"
            dprint "ERROR" "invalid ipv6_gateway:${NEW_IPV6_GATEWAY}."
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
        fi
    fi

    if [ "${NEW_IPV6_GATEWAY}" != "" ]; then
	if ! $(are_in_the_same_ipv6_subnet "${NEW_IPV6_ADDRESS}" "${NEW_IPV6_GATEWAY}" "${NEW_IPV6_PREFIX_LENGTH}" ) ; then
	    output_invalid "12" "invalid ipv6_gateway"
            dprint "ERROR" "invalid ipv6_gateway:${NEW_IPV6_GATEWAY}."
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
        fi
    fi

     local new_ipv6=`echo ${NEW_IPV6_ADDRESS} | tr "[:upper:]" "[:lower:]"`
     local current_ipv6=$(${cmd_prefix} ip -f inet6 -o addr show ${INTERFACE} | grep -v 'local' | grep -v 'dynamic' | sed -n '1p' | awk '{print $4}' | sed 's/\/.*$//g' | tr '[:upper:]' '[:lower:]')

     if [ "${current_ipv4}" != "" ] && [ "${new_ipv6}" != "${current_ipv6}" ]; then

        if ${cmd_prefix} /usr/sbin/ndisc6 -q -w 3000 -r 2 ${NEW_IPV6_ADDRESS} ${INTERFACE} >/dev/null 2>&1 ; then
            output_invalid "18" "some other host already uses ipv6 address:${NEW_IPV6_ADDRESS}."
            dprint "ERROR" "some other host already uses ipv6 address:${new_ipv6}."
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
        fi

    
        `${cmd_prefix} /usr/sbin/ping6 -c 1 ${NEW_IPV6_ADDRESS} -I {INTERFACE} >/dev/null 2>&1`
        local RET=$?

        if [ "${RET}" -eq "0" ]; then
            output_invalid "18" "ping6:some other host already uses ipv6 address:${NEW_IPV6_ADDRESS}."
            dprint "ERROR" "ping6:some other host already uses ipv6 address:${NEW_IPV6_ADDRESS}."
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
        fi
    fi
  fi
    # apply and error handling - set DHCP="0" because not suport DHCP from UI
    if [ "${NEW_DNS}" = "" ]; then
        output_invalid "5" "Invalid dns1"
        dprint "ERROR" "Invalid dns1"
        exit 1
    else
      if [ "${NEW_IPV6_ADDRESS}" = "" ]; then
          # No ipv6 address, only v4 dns is allowed
          if ! $(is_ip_address_valid "${NEW_DNS}") ; then
            output_invalid "5" "Invalid dns1"
            dprint "ERROR" "Invalid dns1:${NEW_DNS}."
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
          fi
      else 
          if ! $(is_ip_address_valid "${NEW_DNS}") && ! $(is_ipv6_address_valid "${NEW_DNS}") ; then
            output_invalid "5" "Invalid dns1"
            dprint "ERROR" "Invalid dns1:${NEW_DNS}."
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
          fi
      fi
    fi

    if [ "${NEW_DNS2}" != "" ]; then
      if [ "${NEW_IPV6_ADDRESS}" = "" ]; then
          if ! $(is_ip_address_valid "${NEW_DNS2}") ; then
            output_invalid "6" "Invalid dns2"
            dprint "ERROR" "Invalid dns2:${NEW_DNS2}."
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
          fi
      else
          if ! $(is_ip_address_valid "${NEW_DNS2}") && ! $(is_ipv6_address_valid "${NEW_DNS2}") ; then
            output_invalid "6" "Invalid dns2"
            dprint "ERROR" "Invalid dns2:${NEW_DNS2}."
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
          fi
      fi
    fi

    if [ "${NEW_DNS3}" != "" ]; then
      if [ "${NEW_IPV6_ADDRESS}" = "" ]; then
          if ! $(is_ip_address_valid "${NEW_DNS3}") ; then  
            output_invalid "13" "Invalid dns3"
            dprint "ERROR" "Invalid dns3:${NEW_DNS3}."
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
          fi
      else
          if ! $(is_ip_address_valid "${NEW_DNS3}") && ! $(is_ipv6_address_valid "${NEW_DNS3}") ; then
            output_invalid "13" "Invalid dns3"
            dprint "ERROR" "Invalid dns3:${NEW_DNS3}."
            exit 1 #exit 1 for NetMgntHostIpWebService.java to receive return code 0 and get the std output here
          fi
      fi
    fi


    RET_MSG=`utility_apply_ms_network_conf "0" "$NEW_HOSTNAME" "$NEW_IP_ADDRESS" "$NEW_SUBNET_MASK" "$NEW_GATEWAY" "$NEW_IPV6_ADDRESS" "$NEW_IPV6_PREFIX_LENGTH" "$NEW_IPV6_GATEWAY" "$NEW_DNS" "$NEW_DNS2" "$NEW_DNS3" "$INTERFACE"`
    local RET=$?
    dprint "DEBUG" "utility_apply_ms_network_conf result:${RET} message:${RET_MSG}"
    if [ "${RET}" -ne 0 ]; then
        if [ "${CONFIG_FROM}" == "from_text_ui" ]; then
            RET_MSG=$(echo "$RET_MSG" | sed -e "s/^SYSTEM_ERROR //")           
            output_invalid "8" "$RET_MSG"
        fi
        exit 1
    fi
    
    # apply successfully
    # Update Nginx setting 
    dprint "DEBUG" "Configuration applied successfully, update nginx config."
    local server_mode=$(cat /opt/TrendMicro/Pixiebob/server_mode)
    if [ "${INTERFACE}" == "eth0" ]; then
        # Management port, assign nginx conf file based on server_mode
        conf_file=""
        case "${server_mode}" in
          "ALL")
              conf_file="default_all.conf"
              ;;
           "UC")
              conf_file="default_uc.conf"
              ;;
           "UCRR")
              conf_file="default_ucrr.conf"
              ;;
           "UCLR")
              conf_file="default_uclr.conf"
        esac

        if [ "${conf_file}" != "" ]; then
            rm -f "/etc/nginx/conf.d/${conf_file}"
            cp -f "/opt/TrendMicro/Pixiebob/Server/init/config/nginx/${conf_file}" /etc/nginx/conf.d/
            MGMT_V4_ADDR=`ip -f inet -o addr show eth0 | sed -n '1p' | awk '{print $4}' | sed 's/\/.*$//g'`
            if [ "$MGMT_V4_ADDR" != "" ]; then
                MGMT_V4_LISTEN_STR="listen ${MGMT_V4_ADDR}:443;"
            else
                MGMT_V4_LISTEN_STR=""
            fi

            sleep 5
            MGMT_V6_ADDR=`ip -f inet6 -o addr show eth0 | grep -v tentative |  grep -v 'local' | grep -v 'dynamic' | sed -n '1p' | awk '{print $4}' | sed 's/\/.*$//g' | tr '[a-z]' '[A-Z]'`
            local mgmt_upcase=$(echo ${MGMT_V6_ADDR:0:5} | tr '[a-z]' '[A-Z]')

            if [ "$MGMT_V6_ADDR" != "" ] && [ "${mgmt_upcase}" != "FE80:" ] ; then
                MGMT_V6_LISTEN_STR="listen [${MGMT_V6_ADDR}]:443;"
            else
                MGMT_V6_LISTEN_STR=""
            fi

            sed -i "s/\[MGMT_IPV4\]/${MGMT_V4_LISTEN_STR}/g" "/etc/nginx/conf.d/${conf_file}"
            sed -i "s/\[MGMT_IPV6\]/${MGMT_V6_LISTEN_STR}/g" "/etc/nginx/conf.d/${conf_file}"
            systemctl restart nginx
        fi

    #elif [ "${INTERFACE}" == "eth1" ]; then
        # TODO: port binding related settings
    fi

    # Update TAXII server setting
    dprint "DEBUG" "Configuration applied successfully, update TAXII server setting."
    if [ "${INTERFACE}" == "eth0" ]; then
        cp -f "/opt/TrendMicro/Pixiebob/Server/init/config/taxii/defaults.yml" /opt/TrendMicro/Pixiebob/Server/api/config/

        USE_FQDN=`psql -A -t -U pixiebob -c "select value from tb_system_settings where key = 'local_repository.use_fqdn'"`
        if [ "${USE_FQDN}" == "1" ]; then
          NEW_FQDN=`hostname`
          sed -i "s/\[MGMT_IPV4\]/${NEW_FQDN}/g" "/opt/TrendMicro/Pixiebob/Server/api/config/defaults.yml"
        else
          MGMT_V4_ADDR=`ip -f inet -o addr show eth0 | sed -n '1p' | awk '{print $4}' | sed 's/\/.*$//g'`
          sed -i "s/\[MGMT_IPV4\]/${MGMT_V4_ADDR}/g" "/opt/TrendMicro/Pixiebob/Server/api/config/defaults.yml"
        fi

        TAXII_SERVER_PID=`pgrep -f opentaxii-run-dev`
        if [ "$TAXII_SERVER_PID" != "" ] ; then
          export PYTHONPATH=/opt/TrendMicro/Pixiebob/common_modules/:/opt/TrendMicro/Pixiebob/Server/api/
          python /opt/TrendMicro/Pixiebob/Server/api/third_party_int/taxii_server.pyc >> /opt/TrendMicro/Pixiebob/Server/logs/textUI.log 2>&1
        fi
    fi

    dprint "DEBUG" "Host Name and IP Address changed successfully."
    if [ "${CONFIG_FROM}" == "from_text_ui" ];then
        output_ok
    fi
}

get_settings()
{
    #dprint 0 "debug" "calling function 'get_settings'"

    #utility_load_conf
    local RET=0
    if [ "$RET" -ne 0 ]; then
        #dprint 0 "err" "Error: utility_load_conf return $RET"
        output_error "Internal Server error"
    else
		virtual_ip4=`echo "${conf_ms_virtual_ip}"|awk -F "|" '{print $1}'`
		virtual_ip6=`echo "${conf_ms_virtual_ip}"|awk -F "|" '{print $2}'`
		if [ $virtual_ip4 = "N/A" ]; then
		  virtual_ip4=""
		fi
		if [ $virtual_ip6 = "N/A" ]; then
		  virtual_ip6=""
		fi
        output_settings "${conf_hostname}" "${conf_ms_ip}" "${conf_ms_netmask}" \
            "${conf_ms_gateway}" "${conf_ms_dns}" "${conf_ms_dns2}" \
            "${conf_ms_ipv6}" "${conf_ms_ipv6_prefix_length}" \
            "${conf_ms_ipv6_gateway}" "${conf_ms_ipv6_dns}" "${conf_ms_ipv6_dns2}" \
			"${virtual_ip4}" "${virtual_ip6}"
    fi
}

output_error()
{
    echo "{"
    echo "\"status\" : ${NETWORK_SETTINGS_HOSTNAME_IP_RET_CODE_ERROR},"
    echo "\"message\" : \"${1}\","
    echo "\"msglevel\" : \"error\""
    echo "}"
}

output_ok()
{
    echo "{"
    echo "\"status\" : ${NETWORK_SETTINGS_HOSTNAME_IP_RET_CODE_OK},"
    echo "\"message\" : \"ok\","
    echo "\"msglevel\" : \"info\""
    echo "}"
}

output_settings()
{
     echo "{"
     echo "\"status\" : 1,"
     echo "\"message\" : \"ok\","
     echo "\"msglevel\" : \"info\","
     echo "\"value\" : {"
     echo "\"hostname\" : \"${1}\","
     echo "\"ip_address\" : \"${2}\","
     echo "\"subnet_mask\" : \"${3}\","
     echo "\"gateway\" : \"${4}\","
     echo "\"dns1\" : \"${5}\","
     echo "\"dns2\" : \"${6}\"",
     echo "\"ipv6_address\" : \"${7}\"",
     echo "\"ipv6_prefix_length\" : \"${8}\"",
     echo "\"ipv6_gateway\" : \"${9}\"",
     echo "\"ipv6_dns1\" : \"${10}\"",
     echo "\"ipv6_dns2\" : \"${11}\"",
	 echo "\"ipv4_virtual\" : \"${12}\"",
	 echo "\"ipv6_virtual\" : \"${13}\""
     echo "}"
     echo "}"
}

output_invalid()
{
     echo "{"
     echo "\"status\" : 1,"
     echo "\"message\" : \"invalid\","
     echo "\"msglevel\" : \"info\","
     echo "\"value\" : {"
     echo "\"err_code\" : \"${1}\","
     echo "\"err_message\" : \"${2}\""
     echo "}"
     echo "}"
}

############################## main program begin ##############################
NETWORK_SETTINGS_HOSTNAME_IP_RET_CODE_OK="1"
NETWORK_SETTINGS_HOSTNAME_IP_RET_CODE_ERROR="-1"

. /opt/TrendMicro/Pixiebob/textUI/constants.sh
. /opt/TrendMicro/Pixiebob/textUI/strings.sh
. /opt/TrendMicro/Pixiebob/textUI/utility.sh
. /opt/TrendMicro/Pixiebob/textUI/common.sh
#. "/opt/TrendMicro/DTAS/cluster/utility/ddan_ha_utils.sh"

NETWORK_SETTINGS_HOSTNAME_IP_CMD=$1
NETWORK_SETTINGS_HOSTNAME_IP_HOSTNAME=$2
NETWORK_SETTINGS_HOSTNAME_IP_IP_ADDRESS=$3
NETWORK_SETTINGS_HOSTNAME_IP_SUBNET_MASK=$4
NETWORK_SETTINGS_HOSTNAME_IP_GATEWAY=$5
NETWORK_SETTINGS_HOSTNAME_IPV6_ADDRESS=$6
NETWORK_SETTINGS_HOSTNAME_IPV6_PREFIX_LENGTH=$7
NETWORK_SETTINGS_HOSTNAME_IPV6_GATEWAY=$8
NETWORK_SETTINGS_HOSTNAME_IP_DNS=$9
NETWORK_SETTINGS_HOSTNAME_IP_DNS2=${10}
NETWORK_SETTINGS_HOSTNAME_IP_DNS3=${11}
NETWORK_SETTINGS_HOSTNAME_IP_CONFIG_FROM=${12}
NETWORK_SETTINGS_HOSTNAME_IP_INTERFACE=${13}

if [ "$NETWORK_SETTINGS_HOSTNAME_IP_CMD" == "get" ]; then
    get_settings
elif [ "$NETWORK_SETTINGS_HOSTNAME_IP_CMD" == "set" ]; then
    # Check ifcfg file for add nic case
    if [ ! -f "/etc/sysconfig/network-scripts/ifcfg-${NETWORK_SETTINGS_HOSTNAME_IP_INTERFACE}" ]; then
        dprint "DEBUG" "The ifcfg file /etc/sysconfig/network-scripts/ifcfg-${NETWORK_SETTINGS_HOSTNAME_IP_INTERFACE} does not exist, create from template." 
        /usr/bin/cp -f "/opt/TrendMicro/Pixiebob/Server/init/config/ifcfg/ifcfg-temp" "/etc/sysconfig/network-scripts/ifcfg-${NETWORK_SETTINGS_HOSTNAME_IP_INTERFACE}"
        sed -i -e "s/^NAME=.*\$/NAME=${NETWORK_SETTINGS_HOSTNAME_IP_INTERFACE}/g" -e "s/^DEVICE=.*\$/DEVICE=${NETWORK_SETTINGS_HOSTNAME_IP_INTERFACE}/g" -e "s/^UUID=.*\$/UUID=$(uuidgen)/g" "/etc/sysconfig/network-scripts/ifcfg-${NETWORK_SETTINGS_HOSTNAME_IP_INTERFACE}"
    fi


    if [ "${NETWORK_SETTINGS_HOSTNAME_IP_INTERFACE}" == "eth1" ]; then
        dprint "DEBUG" "Enable port binding case."
        netns_list=`/usr/sbin/ip netns list | sed -n '1p'`
        if [ "${netns_list}" == "" ]; then
            dprint "DEBUG" "Network namespace not initialized, initialize it..."
            MSG=`/usr/sbin/ip netns add sys-port-ns`
            RET=$?        
            dprint "DEBUG" "Add network namespace result:[${RET}], message:[${MSG}]"
            if [ "${RET}" -ne 0 ]; then
                dprint "ERROR" "Fail to initialize network namespace for system port network, return."
                output_invalid "999" "Fail to initialize network namespace for system port network."
                exit 1
            fi

            MSG=`/usr/sbin/ip netns exec sys-port-ns ip link set dev lo up`
            RET=$?
            dprint "DEBUG" "Bring up lo network result:[${RET}], message:[${MSG}]"
            if [ "${RET}" -ne 0 ]; then
                dprint "ERROR" "Fail to initialize network namespace for system port network, return."
                output_invalid "999" "Fail to initialize network namespace for system port network."
                exit 1
            fi

            MSG=`/usr/sbin/ip link set eth1 netns sys-port-ns`
            RET=$?
            dprint "DEBUG" "Set eth1 to network namespace result:[${RET}], message:[${MSG}]"
            if [ "${RET}" -ne 0 ]; then
                dprint "ERROR" "Fail to initialize network namespace for system port network, return."
                output_invalid "999" "Fail to initialize network namespace for system port network."
                exit 1
            fi
        else
            dprint "DEBUG" "Network namespace already initialized, skip..."    
        fi
    fi

    set_settings "$NETWORK_SETTINGS_HOSTNAME_IP_HOSTNAME" "$NETWORK_SETTINGS_HOSTNAME_IP_IP_ADDRESS" "$NETWORK_SETTINGS_HOSTNAME_IP_SUBNET_MASK" "$NETWORK_SETTINGS_HOSTNAME_IP_GATEWAY" "$NETWORK_SETTINGS_HOSTNAME_IPV6_ADDRESS" "$NETWORK_SETTINGS_HOSTNAME_IPV6_PREFIX_LENGTH" "$NETWORK_SETTINGS_HOSTNAME_IPV6_GATEWAY" "$NETWORK_SETTINGS_HOSTNAME_IP_DNS" "$NETWORK_SETTINGS_HOSTNAME_IP_DNS2" "$NETWORK_SETTINGS_HOSTNAME_IP_DNS3" "$NETWORK_SETTINGS_HOSTNAME_IP_CONFIG_FROM" "$NETWORK_SETTINGS_HOSTNAME_IP_INTERFACE"
fi

############################## main program end ##############################

